/*
   NTRARP.H - include file for kernel-mode driver NTRARP

   Free software Copyright (c) 1997-2002 Lew Perin

*/

#ifndef __NTRARP_H__
#define __NTRARP_H__

#pragma warning(disable: 4201 4214 4010 4115) // Microsoft is excused...
#include <ndis.h>
#include <ntddndis.h>
#pragma warning(default: 4201 4214 4010 4115) // but we aren't
#include "rarpdbg.h"
#pragma warning(disable: 4100)  // unreferenced formal parameter
#pragma warning(disable: 4514)  // unreferenced inline function removed

/*
  Now some constants from WINIOCTL.H:
*/

#define FILE_DEVICE_UNKNOWN             0x00000022
#define METHOD_NEITHER                  3
#define FILE_ANY_ACCESS                 0
#define CTL_CODE( DeviceType, Function, Method, Access ) (  \
((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)

#define htons(a) (USHORT)((((a) & 0xff) << 8) + (((a) & 0xff00) >> 8))

#include "..\shared.h"

#define HOOK_DEBUG 1             /* Trace our hooking of NdisSend()?  */

#define NTRARP_Major 1
#define NTRARP_Minor 2
#define NTRARP_DeviceID UNDEFINED_DEVICE_ID

#define NTRARP_NDIS_MAJOR_VERSION	0x04
#define NTRARP_NDIS_MINOR_VERSION	0x00

#define TRANSPORT_NAME "NTRARP"

#define MAX_REQUESTS 4
#define MAX_TRANSMITS 2

typedef struct _RarpReserved   { // must be <= 16 bytes for receive packet
  LIST_ENTRY listElement;
  PIRP irpP;
  PMDL mdlP;
}
RarpReserved, *PRarpReserved;

#define RESERVED(_p) ((PRarpReserved)((_p)->ProtocolReserved))

typedef struct _RarpReqNtry 
{
  LIST_ENTRY listElement;
  PIRP irpP;                    // associated IRP, if any
  NDIS_REQUEST request;
} 
RarpReqNtry, *PRarpReqNtry;

/*
  Device extension
*/

/*
  Port device extension.  The symbolicLink buffer points
  into the deviceName buffer, so it mustn't be freed.
*/

typedef struct _DeviceExtension {
  PDEVICE_OBJECT deviceObjectP;
  NDIS_STRING macName;
  NDIS_STRING deviceName;
  NDIS_STRING symbolicLink;
} DeviceExtension, *PDeviceExtension;

enum { TokenRingRoutingInfoIndicator = 0x80 }; // applied to TR source address

typedef struct _TokenRingHeader { // for our output: broadcast w/routing info
  UCHAR accessControl;
  UCHAR frameControl;
  UCHAR destination[MacAddressSize];
  UCHAR source[MacAddressSize];
  UCHAR routingInfo[2];
  LLCSNAP llcSnap;
} TokenRingHeader;

typedef union _MacHeaderPayload {
  TokenRingHeader tr;
  RFC894Header eth;
} MacHeaderPayload;             // room for Ethernet or Token Ring

typedef struct _TxMacHeaderNtry {
  LIST_ENTRY listElement;       // must be first!
  MacHeaderPayload payload;     // room for Ethernet or Token Ring
} TxMacHeaderNtry, *PTxMacHeaderNtry;

typedef struct _TxArpPacketNtry {
  LIST_ENTRY listElement;       // must be first!
  ArpPacket payload;
} TxArpPacketNtry, *PTxArpPacketNtry;

typedef struct _OpenInstance 
{
  PDEVICE_OBJECT deviceObjectP;
  PIRP openOrCloseIrpP;         // convenience for xxCompleteHandler
  PIRP cleanupIrpP;             // IRP for MJ_CLEANUP dispatch routine
  NDIS_HANDLE adapterHandle;    // returned from NdisOpenAdapter
  NDIS_SPIN_LOCK requestSpinLock;
  LIST_ENTRY requestList;
  RarpReqNtry requests[MAX_REQUESTS];
  NDIS_SPIN_LOCK txMacHeaderSpinLock;
  LIST_ENTRY txMacHeaderList;
  TxMacHeaderNtry txMacHeaders[MAX_TRANSMITS];
  NDIS_SPIN_LOCK txArpPacketSpinLock;
  LIST_ENTRY txArpPacketList;
  TxArpPacketNtry txArpPackets[MAX_TRANSMITS];
  NDIS_HANDLE packetPool;
  LIST_ENTRY rcvList;
  UCHAR macAddress[MacAddressSize];
  union {
    NDIS_MEDIUM medium;
    UINT selectedMediumIndex;
  } u1;
  UINT packetFilter;
  int promiscuous;              // are we accepting any old packet?
  /* Now come statuses that we keep around so we can dump 'em: */
  NDIS_STATUS openErrorStatus;
  NDIS_STATUS macAddressReqStatus;
  NDIS_STATUS setFilterReqStatus;
  NDIS_STATUS transferDataStatus;
} 
OpenInstance, *POpenInstance;

#define  NPackets 16            // total # of packets for xmit & receive

NTSTATUS DriverEntry(IN PDRIVER_OBJECT adriverObjectP,
                     IN PUNICODE_STRING aregistryPathP);

/*
  Functions called out in the driver object:
*/

VOID RarpUnload(IN PDRIVER_OBJECT adriverObjectP);

NTSTATUS RarpOpen(IN PDEVICE_OBJECT adeviceObjectP, IN PIRP airpP);

NTSTATUS RarpClose(IN PDEVICE_OBJECT adeviceObjectP, IN PIRP airpP);

NTSTATUS RarpWrite(IN PDEVICE_OBJECT adeviceObjectP, IN PIRP airpP);

NTSTATUS RarpRead(IN PDEVICE_OBJECT adeviceObjectP, IN PIRP airpP);

NTSTATUS RarpIoControl(IN PDEVICE_OBJECT adeviceObjectP, IN PIRP airpP);

NTSTATUS RarpCleanup(IN PDEVICE_OBJECT adeviceObjectP, IN PIRP airpP);

/*
   NDIS 4.0 PROTOCOL FUNCTION PROTOTYPES
*/

VOID
RarpOpenAdapterCompleteHandler(IN NDIS_HANDLE abindingContext,
                               IN NDIS_STATUS astatus,
                               IN NDIS_STATUS aopenErrorStatus);

VOID
RarpCloseAdapterCompleteHandler(IN NDIS_HANDLE abindingContext,
                                IN NDIS_STATUS astatus);

VOID
RarpSendCompleteHandler(IN NDIS_HANDLE abindingContext,
                        IN PNDIS_PACKET apacket,
                        IN NDIS_STATUS astatus);

VOID
RarpTransferDataCompleteHandler(IN NDIS_HANDLE abindingContext,
                                IN PNDIS_PACKET apacket,
                                IN NDIS_STATUS astatus,
                                IN UINT abytesTransferred);

VOID
RarpResetCompleteHandler(IN NDIS_HANDLE abindingContext,
                         IN NDIS_STATUS astatus);

VOID
RarpRequestCompleteHandler(IN NDIS_HANDLE abindingContext,
                           IN PNDIS_REQUEST andisRequest,
                           IN NDIS_STATUS astatus);

NDIS_STATUS
RarpReceiveHandler(IN NDIS_HANDLE abindingContext,
                   IN NDIS_HANDLE amacReceiveContext,
                   IN PVOID aheaderBuffer,
                   IN UINT aheaderBufferSize,
                   IN PVOID alookAheadBuffer,
                   IN UINT alookaheadBufferSize,
                   IN UINT apacketSize);

VOID
RarpReceiveCompleteHandler(IN NDIS_HANDLE NdisBindingContext);

VOID
RarpStatusHandler(IN NDIS_HANDLE abindingContext,
                  IN NDIS_STATUS ageneralStatus,
                  IN PVOID astatusBuffer,
                  IN UINT astatusBufferSize);

VOID
RarpStatusCompleteHandler(IN NDIS_HANDLE abindingContext);

VOID
RarpBindAdapterHandler(OUT PNDIS_STATUS astatus,
                       IN  NDIS_HANDLE abindAdapterContext,
                       IN  PNDIS_STRING anadapterName,
                       IN  PVOID asystemSpecific1,
                       IN  PVOID asystemSpecific2);

VOID
RarpUnbindAdapterHandler(OUT PNDIS_STATUS astatus,
                         IN  NDIS_HANDLE aprotocolBindingContext,
                         IN  NDIS_HANDLE anunbindAdapterContext);

/*
  Non-NDIS Prototypes
*/

NDIS_STATUS
RarpAllocatePacketBuffer(POpenInstance pOpen,
                         PNDIS_PACKET *pPacket, // 17.2.97
                         PIO_STACK_LOCATION aPISL);

void RarpDisconnect(PIO_STACK_LOCATION aPISL);

void RarpCancelReadIrp(IN PDEVICE_OBJECT adeviceObjectP, IN PIRP airpP);

/*
   PROTOCOL CONTEXT

   We only have one of these structures for the Protocol KMD.
   When updating this structure, remember that there's a reason for the
   way its members are ordered: the needs of the IOCTL to dump the driver's
   guts.  Make sure the global stuff comes first, followed by the adapter
   contexts, and lastly (what doesn't need to be dumped) the packet buffer.
*/

typedef struct _ProtocolBlock {
  NDIS_HANDLE ndisProtocolHandle;     // returned from NdisRegisterProtocol
} ProtocolBlock, *PProtocolBlock;

extern ProtocolBlock rarpContext;

#endif // __NTRARP_H__


