/*
  Declarations for debugging, derived from the intermediate NDIS driver
  sample IMSAMP published by Microsoft.
*/

#ifndef _RARPDBG_
#define _RARPDBG_

//
// Debug Level and Mask definitions.
//

#define DBG_DEATH               1
#define DBG_CRITICAL_ERROR      2
#define DBG_FAILURE             4
#define DBG_INFO                6
#define DBG_TRACE               8
#define DBG_VERBOSE             10

#define DBG_INIT                0x00000001
#define DBG_MINIPORT            0x00000002
#define DBG_PROTOCOL            0x00000004
#define DBG_SEND                0x00000008
#define DBG_RECEIVE             0x00000410 // see DBG_RX_ALL
#define DBG_IO                  0x00000020
#define DBG_MEMORY              0x00000040
#define DBG_CM                  0x00000080
#define DBG_REFCNTS             0x00000100
#define DBG_VC                  0x00000200
#define DBG_TIMERQ              0x00000400
#define DBG_RX_ALL              0x00000800 | DBG_RECEIVE
#define DBG_ALL                 0xFFFFFFFF

//
// these tags are used in Lookaside lists therefore need to be available regardless of
// the type of build
//

extern ULONG NdisRequestTag;
extern ULONG NdisReqCompletionCtxtTag;
extern ULONG PLogTag;
extern ULONG AdapterVCTag;
extern ULONG ClientVCTag;

//
// NT Debugging routines
//

#if DBG

//
// signatures for data structures
//

extern ULONG AdapterTag;
extern ULONG AdapterVCTag;
extern ULONG ClientTag;
extern ULONG ClientVCTag;
extern ULONG CMParamsTag;
extern ULONG DevInstanceTag;
extern ULONG LookaheadBufferTag;
extern ULONG MediaAreaTag;
extern ULONG PacketArrayTag;
extern ULONG PacketContextTag;
extern ULONG PacketTag;
extern ULONG ResidualBufferTag;
extern ULONG WQItemTag;

extern CHAR VersionNumber[];
extern CHAR VersionHerald[];
extern CHAR VersionTimestamp[];

#define DEBUGCHK    DbgBreakPoint()

#define STATIC

//
// these correspond to DebugLevel and DebugMask in ImSamp\Parameters
//

extern ULONG DbgTraceLevel;
extern ULONG DbgTraceMask;

#define RarpDbgOut(_DebugLevel, _DebugMask, _Out) {   \
    if ((DbgTraceLevel >= _DebugLevel) &&           \
        ((_DebugMask) & DbgTraceMask)) {            \
        DbgPrint("RARP: ");                       \
        DbgPrint _Out;                              \
    }                                               \
}

#define RarpTrace(_Out) { \
  if ((DbgTraceLevel >= DBG_TRACE) && \
      (DBG_ALL & DbgTraceMask)) { \
    DbgPrint("RARP: " # _Out); \
  } \
}

#define RarpTraceMask(_dbgmask, _Out) { \
  if ((DbgTraceLevel >= DBG_TRACE) && \
      (_dbgmask & DbgTraceMask)) { \
    DbgPrint("RARP: " # _Out); \
  } \
}

#define RarpTrace2(_fmt, _arg1) { \
  if ((DbgTraceLevel >= DBG_TRACE) && \
      (DBG_ALL & DbgTraceMask)) { \
    DbgPrint("RARP: " #_fmt, _arg1); \
  } \
}

#define RarpTrace2Mask(_dbgmask, _fmt, _arg1) { \
  if ((DbgTraceLevel >= DBG_TRACE) && \
      (_dbgmask & DbgTraceMask)) { \
    DbgPrint("RARP: " #_fmt, _arg1); \
  } \
}

#define RarpTrace3(_fmt, _arg1, _arg2) { \
  if ((DbgTraceLevel >= DBG_TRACE) && \
      (DBG_ALL & DbgTraceMask)) { \
    DbgPrint("RARP: " #_fmt, _arg1, _arg2); \
  } \
}

#define RarpTrace3Mask(_dbgmask, _fmt, _arg1, _arg2) { \
  if ((DbgTraceLevel >= DBG_TRACE) && \
      (_dbgmask & DbgTraceMask)) { \
    DbgPrint("RARP: " #_fmt, _arg1, _arg2); \
  } \
}

#define RarpTrace4(_fmt, _arg1, _arg2, _arg3) { \
  if ((DbgTraceLevel >= DBG_TRACE) && \
      (DBG_ALL & DbgTraceMask)) { \
    DbgPrint("RARP: " #_fmt, _arg1, _arg2, _arg3); \
  } \
}

#define RarpTrace4Mask(_dbgmask, _fmt, _arg1, _arg2, _arg3) { \
  if ((DbgTraceLevel >= DBG_TRACE) && \
      (_dbgmask & DbgTraceMask)) { \
    DbgPrint("RARP: " #_fmt, _arg1, _arg2, _arg3); \
  } \
}

#define RarpDbgOutNoID(_DebugLevel, _DebugMask, _Out) {   \
    if ((DbgTraceLevel >= _DebugLevel) &&               \
        ((_DebugMask) & DbgTraceMask)) {                \
        DbgPrint _Out;                                  \
    }                                                   \
}

#define KdPrint( x )    DbgPrint x

#define STRUCT_TAG     ULONG Tag

#define RARPSetTag( s, t ) (s)->Tag = t##Tag

#define RARPStructAssert( _tag ) if ((_tag) != NULL && (_tag)->Tag != _tag##Tag) {\
    DbgPrint( "RARP: structure assertion failure for type " #_tag " in file " __FILE__ " line %d\n", __LINE__ );\
    DEBUGCHK;\
    }

// same thing but when structure name is different from tag name

#define RARPStructAssert1( _struct, _tag ) if ((_struct) != NULL && (_struct)->Tag != _tag##Tag) {\
    DbgPrint( "RARP: structure assertion failure for type " #_tag " in file " __FILE__ " line %d\n", __LINE__ );\
    DEBUGCHK;\
    }

#define RARPAssert(c)    if (!(c)) {\
    DbgPrint( "RARP: assertion @ line %d in file " __FILE__ " \n", __LINE__ );\
    DEBUGCHK;\
    }

//
// allocate memory from nonpaged pool and set the tag in the checked
// version of the structure
//

#define RARPAllocatePool( _addr, _size, _tag )  \
    _addr = ExAllocatePoolWithTag( NonPagedPool, (_size), (_tag##Tag));    \
    if ( _addr ) {                                                         \
        NdisZeroMemory( _addr, _size );                                    \
        _addr->Tag = _tag##Tag;                                            \
        RarpDbgOut( DBG_VERBOSE, DBG_MEMORY, ("Mem Alloc'ed %08x for %6d bytes\n", _addr, _size )); \
    }

#define RARPAllocatePoolNoStructTag( _addr, _size, _tag )  \
    _addr = ExAllocatePoolWithTag( NonPagedPool, (_size), (_tag##Tag));    \
    if ( _addr ) {                                                         \
        NdisZeroMemory( _addr, _size );                                    \
        RarpDbgOut( DBG_VERBOSE, DBG_MEMORY, ("Mem Alloc'ed %08x for %6d bytes\n", _addr, _size )); \
    }

#define RARPFreePool( _addr )         \
    ExFreePool( _addr );            \
    RarpDbgOut( DBG_VERBOSE, DBG_MEMORY, ("Mem Freed    %08x\n", _addr ))

#else // DBG

#define DEBUGCHK
#define RarpDbgOut(s,t,u)
#define RarpTrace(_Out)
#define RarpDbgOutNoID(s,t,u)
#define KdPrint( x )
#define STRUCT_TAG            /##/
#define RARPSetTag( s, t )
#define RARPStructAssert( t )
#define RARPStructAssert1( s, t )
#define RARPAssert(c)

#define RARPAllocatePool( _addr, _size, _tag )        \
    _addr = ExAllocatePool( NonPagedPool, (_size)); \
    if ( _addr ) {                                  \
        NdisZeroMemory( _addr, _size );             \
    }

#define RARPAllocatePoolNoStructTag( _addr, _size, _tag )  \
    _addr = ExAllocatePool( NonPagedPool, (_size));     \
    if ( _addr ) {                                  \
        NdisZeroMemory( _addr, _size );             \
    }

#define RARPFreePool( _addr )  ExFreePool( _addr )

#define STATIC static

#endif // DBG

#endif /* _RARPDBG_ */

/* end debug.h */
