/*

   SHARED.H - include file for KMD NTRARP

   Free software Copyright (c) 1996 Lew Perin

   Contains the definition for what's shared between rarpd.exe
   and ntrarp.sys

*/

#pragma pack(1)

enum { MacAddressSize = 6 };

/*

   W32 IOCTL command definitions: First we declare the raw function codes
   and then, with the aid of the CTL_CODE macro, the finished IOCTL codes.

*/

enum {
  FnCode_RarpAwaitRarp = 0x800,
  FnCode_RarpAwaitAny,
  FnCode_RarpGetVersion,
  FnCode_RarpGetMacAddress,
  FnCode_RarpDumpDriver,
  FnCode_RarpGetHWType,
  FnCode_RarpBind
};

enum {
  DIOC_RarpAwaitRarp =
    CTL_CODE(FILE_DEVICE_UNKNOWN, FnCode_RarpAwaitRarp,
             METHOD_BUFFERED, FILE_ANY_ACCESS),
  DIOC_RarpAwaitAny =
    CTL_CODE(FILE_DEVICE_UNKNOWN, FnCode_RarpAwaitAny,
             METHOD_BUFFERED, FILE_ANY_ACCESS),
  DIOC_RarpGetVersion =
    CTL_CODE(FILE_DEVICE_UNKNOWN, FnCode_RarpGetVersion,
             METHOD_BUFFERED, FILE_ANY_ACCESS),
  DIOC_RarpGetMacAddress =
    CTL_CODE(FILE_DEVICE_UNKNOWN, FnCode_RarpGetMacAddress,
             METHOD_BUFFERED, FILE_ANY_ACCESS),
  DIOC_RarpDumpDriver =
    CTL_CODE(FILE_DEVICE_UNKNOWN, FnCode_RarpDumpDriver,
             METHOD_BUFFERED, FILE_ANY_ACCESS),
  DIOC_RarpGetHWType =
    CTL_CODE(FILE_DEVICE_UNKNOWN, FnCode_RarpGetHWType,
             METHOD_BUFFERED, FILE_ANY_ACCESS),
  DIOC_RarpBind =
    CTL_CODE(FILE_DEVICE_UNKNOWN, FnCode_RarpBind,
             METHOD_BUFFERED, FILE_ANY_ACCESS)
};

/*
   Ethernet headers from W. R. Stevens, TCP/IP Illustrated, vol. 1,
   Fig. 2.1
*/

typedef struct {
  UCHAR destination[MacAddressSize];
  UCHAR source[MacAddressSize];
  USHORT packetType;
} RFC894Header;

typedef struct {
  UCHAR dsap;
  UCHAR ssap;
  UCHAR cntl;
  UCHAR orgCode[3];
  USHORT packetType;
} LLCSNAP;

/*
  Enums are in network byte order:
*/
enum {
  PacketTypeRARP = 0x8035,
  ProtocolTypeIP = 0x0800
};

enum RarpHWType {
  RarpHWTypeEthernet = 1, RarpHWTypeIEEE = 6
};

enum RarpOp {
  RarpOpRequest = 3, RarpOpReply = 4
};

typedef struct {
  USHORT hwType;                // h/w address type, 1 = 10 mb ethernet
  USHORT protType;              // protocol type
  UCHAR hwLen;                  // h/w address len, eg '6' for 10mb eth
  UCHAR protLen;                // protocol addr size, 4 for IP
  USHORT op;                    // request/reply type
  UCHAR senderMacAddress[MacAddressSize];
  ULONG senderProtAddress;
  UCHAR targetMacAddress[MacAddressSize];
  ULONG targetProtAddress;
} ArpPacket, *PArpPacket;

/*
  Not all of this structure is used everywhere.  Wait, I can explain.
  The ARP packet is the same as the RARP packet; it's used by the RARP
  client and server in input and output, which is to say, everywhere.
  The remote MAC address is given to the driver on output by the server,
  which has to specify the destination, which may be different from the
  target; the client doesn't specify it, letting the driver use the
  broadcast address.  On input the server must leave space for the remote
  MAC address but the client will have no use for it.
*/

typedef struct {
  ArpPacket ap;
  UCHAR remoteMacAddress[MacAddressSize]; // not in actual [R]ARP packet
} RarpBuf, *PRarpBuf;
