#include "TiffSubs.h"
#include <iomanip.h>

TIFFLong TIFFTag::ValueSize(void)
  {
  switch(ValueType)
    {
   case  1:
   case  2:
   case  6:
   case  7:
    return ValueCount;
   case  3:
   case  8:
    return ValueCount << 1;
   case  4:
   case  9:
   case 11:
    return ValueCount << 2;
   case  5:
   case 10:
   case 12:
    return ValueCount << 3;
   default:
    return 0;
    }
  }

const char *TIFFTag::Name(void)
  {
  switch (TagType)
    {
    case   256: return "ImageWidth";
    case   257: return "ImageLength";
    case   258: return "BitsPerSample";
    case   259: return "Compression";
    case   262: return "PhotometricInterpretation";
    case   271: return "Make";
    case   272: return "Model";
    case   273: return "StripOffsets";
    case   274: return "Orientation";
    case   277: return "SamplesPerPixel";
    case   278: return "RowsPerStrip";
    case   279: return "StripByteCounts";
    case   282: return "XResolution";
    case   283: return "YResolution";
    case   284: return "PlanarConfiguration";
    case   296: return "ResolutionUnit";
    case   305: return "Software";
    case   306: return "DateTime";
    case   513: return "JPEGDataOffset";
    case   514: return "JPEGDataLength";
    case 34665: return "EXIF IFD";
    case 33434: return "ExposureTime";
    case 33437: return "F-Number";
    case 34850: return "ExposureProgram";
    case 34855: return "ISO Speed";
    case 36864: return "EXIF Version";
    case 36867: return "DateTimeOriginal";
    case 36868: return "DateTimeDigitized";
    case 37380: return "ExposureBiasValue";
    case 37383: return "MeteringMode";
    case 37385: return "Flash";
    case 37386: return "FocalLength";
    case 37500: return "MakerNote";
    case 40960: return "Flashpix Version";
    case 40961: return "Color Space";
    case 41495: return "SensingMethod";
    case 41728: return "FileSource";
    case 41729: return "SceneType";
    case 41730: return "CFAPattern";
    case 41985: return "CustomRendered";
    case 41986: return "ExposureMode";
    case 41987: return "WhiteBalance";
    case 41989: return "FocalLengthIn35mm";
    case 41990: return "SceneCaptureType";
    case 41992: return "Contrast";
    case 41993: return "Saturation";
    case 41994: return "Sharpness";
    case 41996: return "SubjectDistanceRange";
    }
  return "????";
  }


TIFFTag *TIFFIFD::Find(TIFFWord TagType)
  {
  TIFFLong  index;

  for (index = 0 ; index < count ; index++)
   if (tag[index].TagType == TagType)
    return &tag[index];
  return NULL;
  }


TIFFIFD *TIFF::ReadIFD(TIFFLong offset)
  {
  TIFFIFD  *IFD;
  TIFFWord  index;
  TIFFTag  *tag;

  if (offset == 0) return NULL;
  Seek(offset);

  IFD = new TIFFIFD;
  ReadWordData(&IFD->count);
  IFD->offset = offset;
  IFD->tag    = tag = new TIFFTag[IFD->count];

  for (index = 0 ; index < IFD->count ; tag++, index++)
    {
    ReadWordData(&tag->TagType);
    ReadWordData(&tag->ValueType);
    ReadLongData(&tag->ValueCount);
    ReadLongData(&tag->ValueOffset);

    tag->ValueData  = tag->ValueOffset;
    if (swap && (tag->ValueSize() <= 4))
      {
      tag->ValueData   = tag->ValueOffset >> 8*(4 - tag->ValueSize());
      tag->ValueOffset = offset + 2 + index*12;
      }
    }
  ReadLongData(&offset);
  IFD->next = ReadIFD(offset);
  return IFD;
  }

TIFF::TIFF(void)
  {
  BaseIFD = NULL;
  ExifIFD = NULL;
  }

TIFF::~TIFF(void)
  {
  TIFFIFD *IFD;

  if (chan.is_open()) chan.close();
  while (IFD = BaseIFD)
    {
    BaseIFD = IFD->next;
    delete IFD;
    }
  delete ExifIFD;
  }

void TIFF::ReadByteData(TIFFByte *data, int count)
  {
  chan.read((char *) data, count*sizeof(TIFFByte));
  }

void TIFF::ReadWordData(TIFFWord *data, int count)
  {
  chan.read((char *) data, count*sizeof(TIFFWord));
  if (swap)
   for (int n = 0 ; n < count ; n++)
    data[n] = ((data[n] << 8) & 0xFF00) | ((data[n] >> 8) & 0x00FF);
  }

void TIFF::ReadLongData(TIFFLong *data, int count)
  {
  chan.read((char *) data, count*sizeof(TIFFLong));
  if (swap)
   for (int n = 0 ; n < count ; n++)
    data[n] = ((data[n] << 24) & 0xFF000000) | ((data[n] <<  8) & 0x00FF0000)
            | ((data[n] >>  8) & 0x0000FF00) | ((data[n] >> 24) & 0x000000FF); 
  }

TIFFTag *TIFF::Find(TIFFWord TagType)
  {
  TIFFIFD *IFD;
  TIFFTag *tag;

  for (int check = 0 ; check < 2 ; check++)
   for (IFD = check ? BaseIFD : ExifIFD ; IFD ; IFD = IFD->next)
    if (tag = IFD->Find(TagType)) return tag;
  return NULL;
  }

void TIFF::ScanJPEGData(TIFFLong start, TIFFLong limit)
  {
  TIFFByte  ByteData;
  TIFFWord  WordData,MarkCode, nRows, nCols;
  TIFFLong  offset = 0, length = limit;

  Seek(start);

  while (length >= 2)
    {
    ReadWordData(&MarkCode);
    offset += 2;
    length -= 2;
    switch (MarkCode)
      {
     case 0xFFD8: // SOI
      continue;

     case 0xFFC0: // SOF
     case 0xFFC4: // DQT
     case 0xFFDA: // SOS
     case 0xFFDB: // DQT
     case 0xFFDD: // DRI
      if (length < 2) return;
      ReadWordData(&WordData);
//    cout << "Marker at " << hex << setw(5) << offset-2 << ":  " << MarkCode << ", length " << setw(3) << WordData << " (" << dec << WordData << ")" << endl;
      if (length < WordData) return;
      if (MarkCode == 0xFFDA) return;
      offset += WordData;
      length -= WordData;
      if (MarkCode == 0xFFC0)
	{
	ReadByteData(&ByteData);
	ReadWordData(&nRows);
	ReadWordData(&nCols);
	cout << "                                JPEG Image  (" << dec << nCols << "x" << nRows << ")" << endl;
	}
      Seek(start + offset);
      continue;
     default:
      cout << "**** Unknown item at " << hex << setw(5) << offset-2 << ":  " << MarkCode << endl;
      }
    break;
    }
  }

int TIFF::Open(const char *filename)
  {
  TIFFWord check, index;
  TIFFLong offset;
  TIFFIFD  *IFD;
  TIFFTag  *tag;

  chan.open(filename, ios::in | ios::binary | ios::nocreate);
  if (!chan.is_open()) return 0;

  swap = 0;
  ReadWordData(&check);
  switch(check)
    {
   case 0x4D4D: swap ^= 1;
   case 0x4949: break;
   default:
    chan.close();
    return 0;
    }
  ReadWordData(&check);
  switch(check)
    {
   case 0x2A00: swap ^= 1;
   case 0x002A: break;
   default:
    chan.close();
    return 0;
    }
  ReadLongData(&offset);
  BaseIFD = ReadIFD(offset);

  if ((IFD = BaseIFD) && (tag = IFD->Find(34665)))
    ExifIFD = ReadIFD(tag->ValueData);
#if 0
  for (check = 0 ; check < 2 ; check++)
   for (IFD = check ? ExifIFD : BaseIFD ; IFD ; IFD = IFD->next)
    {
    cout << "Directory at " << hex << setw(8) << IFD->offset << ", length " << dec << setw(2) << IFD->count;
#if 1
    cout << "                              " << hex << setw(8) << IFD->offset << " - " << setw(8) << IFD->offset + IFD->count*12 + 5;
#endif
    cout << endl;
    for (tag = IFD->tag, index = 0 ; index < IFD->count ; tag++, index++)
      {
      cout << dec << setw(2) << index << ": " << setw( 5) << tag->TagType
					      << setw( 3) << tag->ValueType
					      << setw( 8) << tag->ValueCount
				       << hex << setw(10) << tag->ValueData
				       << "  " << tag->Name();
#if 1
      if (tag->ValueSize() > 4)
	{
	static char blank[] = "                              ";
	cout << &blank[strlen(tag->Name())];
	cout << setw(8) << tag->ValueOffset << " - " << setw(8) << tag->ValueOffset + tag->ValueSize() - 1;
	}
      if (index && (tag->TagType == 514) && (tag[-1].TagType == 513))
	{
	cout << setw(24) << tag[-1].ValueData << " - " << setw(8) << tag[-1].ValueData + tag->ValueData- 1;
	}
#endif
      cout << endl;
      }
#if 1
    if ((tag = IFD->Find(513)) && IFD->Find(514))
      ScanJPEGData(tag[0].ValueData, tag[1].ValueData);
#endif
    }
#if 1
   if (tag = Find(37500))
     {
     int      inner;
     TIFFByte buffer[16];

     Seek(tag->ValueOffset);
     for (index = 0 ; (index < 0x2000) && (index < tag->ValueCount) ; index += 16)
       {
       ReadByteData(buffer, 16);
       cout << hex << setw(5) << index << ":";
       for (inner = 0 ; inner < 16 ; inner++)
	 cout << setw(3) << (int) buffer[inner];
       cout << "    ";
       for (inner = 0 ; inner < 16 ; inner++)
	 cout << (((buffer[inner] > ' ') && (buffer[inner] < 127)) ? buffer[inner] : '.');
       cout << endl;
       }
     }
#endif
#endif
  return 1;
  }
