#include <fstream.h>

typedef unsigned char      TIFFByte;
typedef unsigned short int TIFFWord;
typedef unsigned long  int TIFFLong;

class TIFFTag
  {
 public:
  TIFFWord    TagType;
  TIFFWord    ValueType;
  TIFFLong    ValueCount;
  TIFFLong    ValueOffset;
  TIFFLong    ValueData;
  TIFFLong    ValueSize();
  const char *Name(void);
  };

class TIFFIFD
  {
 public:
  TIFFIFD  *next;
  TIFFLong  offset;
  TIFFWord  count;
  TIFFTag  *tag;

  TIFFIFD(void) : next(0), tag(0) {}
 ~TIFFIFD(void) {delete [] tag;}

  TIFFTag *Find(TIFFWord TagType);
  };

class TIFF
  {
 protected:
  fstream   chan;
  bool	    swap;
  TIFFIFD  *BaseIFD, *ExifIFD;
 public:
  TIFF(void);
 ~TIFF(void);
 protected:
  TIFFIFD *ReadIFD(TIFFLong offset);
  void     ScanJPEGData(TIFFLong offset, TIFFLong length);
 public:
  int	   Open(const char *filename);
  void	   Seek(TIFFLong offset) {chan.seekp(offset);}
  TIFFTag *Find(TIFFWord TagType);

  void	   ReadByteData(TIFFByte *data, int count = 1);
  void	   ReadWordData(TIFFWord *data, int count = 1);
  void	   ReadLongData(TIFFLong *data, int count = 1);
  };
