#include <stdlib.h>
#include <string.h>

#include "TiffSubs.h"
#include "gd.h"

#define NROWS 2024
#define NCOLS 3040

class PentaxRaw : public TIFF
  {
 protected:
  unsigned short *sensor;
 public:
  PentaxRaw(void) : sensor(0) {};
 ~PentaxRaw(void) { delete sensor; }

  void Load(void);
  unsigned short Sensor(int row, int col) {return sensor ? __max(0, sensor[NCOLS*row + col] - 128) : 0;}
  };

void PentaxRaw::Load(void)
  {
  TIFFTag  *tag;

  if (!sensor) sensor = new unsigned short[NROWS*NCOLS];
  tag = Find(273);
  if (!(tag && (tag->ValueCount == 1) && sensor)) return;
  Seek(tag->ValueData);

  ReadWordData(sensor, NROWS*NCOLS);
  }

int main(int argc, char *argv[])
  {
  PentaxRaw pef;
  int	    row, col, balance = 0;
  double    scale[9][3] = {{1.000, 1.000, 1.000},
			   {2.167, 1.413, 1.318},
			   {2.378, 1.413, 1.175},
			   {2.566, 1.413, 1.071},
			   {2.746, 1.413, 1.383},
			   {2.294, 1.413, 1.548},
			   {2.074, 1.413, 1.893},
			   {1.336, 1.413, 2.826},
			   {2.566, 1.413, 1.196}};

  if ((argc > 2) && pef.Open(argv[1]))
    {
    TIFFByte  R, G, B, convert[16384];
    TIFFTag  *tag;

    if (argc > 3) balance = atoi(argv[3]);

    pef.Load();

    for (int n = 0 ; n < 4096 ; n++) convert[n] = n >> 4;
    memset(&convert[4096], 0xFF, sizeof(convert) - 4096);

    if (tag = pef.Find(37500))
      {
      pef.Seek(tag->ValueOffset + 0xF00);
      pef.ReadByteData(convert, 4096);
      }

    gdImagePtr image = gdImageCreateTrueColor(NCOLS/2, NROWS/2);
    for (row = 0 ; row < NROWS ; row += 2)
      {
      for (col = 0 ; col < NCOLS ; col += 2)
	{
	R = convert[(int) (1.0*scale[balance][0]*(pef.Sensor(row+0, col+0)                           ))];
	G = convert[(int) (0.5*scale[balance][1]*(pef.Sensor(row+0, col+1) + pef.Sensor(row+1, col+0)))];
	B = convert[(int) (1.0*scale[balance][2]*(                           pef.Sensor(row+1, col+1)))];
//	R = __min(255, R + (B / 6)); 
        gdImageSetPixel(image, col >> 1, row >> 1, gdImageColorAllocate(image, R, G, B));
	}
      }
    FILE *chan = fopen(argv[2], "wb");
#if 1
    char *type = strrchr(argv[2], '.');
    if (type && stricmp(type, "jpg")) gdImageJpeg(image, chan, 100); else
#endif
    gdImagePngEx(image, chan, 9);

    fclose(chan);
    gdImageDestroy(image);
    }
  return 0;
  }
